; WordPerfect 7.0 scripts version: 2.0.2
Include "WpWin7.jsm"
include "wpwin7.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"
include "default.jsm"

Script  ScriptFileName()
;announces the name of the aplication and currently executing script.
ScriptAndAppNames ("Corel Wordperfect 7 ")
EndScript

Function AutoStartEvent ()
;Initializes global variables and anounces welcome message.
Let ToolTip = WC_ToolTip ;assigns the tooltip window class name to the variable.
Let AutoSayPageNo = TRUE
If (WP7FirstTime == 0) Then 
	Let WP7FirstTime = TRUE 
	Say(WPMsg3, ot_help)
	Say(WPMsg4, ot_help)
	Say(WPMsg5, ot_help)
Else
	Refresh ()
EndIf 
EndFunction

Int Function ControlCheckMarkDialogs (handle WHnd)
Var
	String TheClass 

Let TheClass = GetWindowClass (WHnd)
;WC_GeneralDialog = #32770 
If TheClass == WC_GeneralDialog then 
	Return TRUE
ElIf (TheClass == WC_PageSetup) Then 
	Return TRUE
else
	Return FALSE
EndIf
 EndFunction

Script  ReadMisspelledAndSuggestion()
var
	handle WinHandle,
	Handle NotFoundField,
	Handle ReplaceField

let WinHandle = GetRealWindow (GetFocus ())
if StringContains (GetWindowName (WinHandle), strg1) then 
	Let Notfoundfield = FindDescendantWindow (WinHandle, CId_NotFound_field)
	Let ReplaceField = FindDescendantWindow (WinHandle, CId_ReplaceWith_field)
	SayWindow (FindDescendantWindow (WinHandle, CId_NotFound_Prompt), 0) 
	SaveCursor ()
	InvisibleCursor ()
	If MoveToWindow (NotFoundField) Then 
		SayChunk ()
			SpellString (GetChunk ())
	EndIf
	Saywindow (FindDescendantWindow (WinHandle, CId_ReplaceWith_Prompt), 0)	
	If MoveToWindow (ReplaceField) Then 
		SayChunk ()
	SpellString (GetChunk ())
	EndIf
;	PerformScript ReadWordInContext ()
else
	Say(WPErrorMsg2, ot_message) ; "you must be in the Spell Checker dialog to read misspelled word and suggestion"
EndIf
RestoreCursor ()
PcCursor ()
endScript

Script ReplaceMisspelledWord ()
var
	handle RealWinHandle, ;Stores the real window handle.
	int controlId ;control Id of the current window with focus.

let RealWinHandle = GetRealWindow (GetFocus ())
Let ControlId = GetcontrolId (GetFocus ())
let ReplaceField = FALSE
Say(GetCurrentScriptKeyName (), ot_control_name)
if StringContains (GetWindowName (RealWinHandle), strg1) then 
	;We are in the spell checker. 
	If (ControlId == CId_ReplaceWith_Field) Then 
		;Move the pc cursor to the replace button.
		{tab}
		{tab}
		Let ReplaceField = TRUE 
	ElIf  (controlId == CId_replacements_list) Then 
		{tab}
		Let ReplaceField = TRUE 
	EndIf ;We are on the Replace with field or the suggestion list.
EndIf ;You are in a spell checker 
{enter}
EndScript

Script  ReadWordInContext()
var
	handle WinHandle,
	Handle PriorWinHandle 

let PriorWinHandle = GetFocus ()
Let WinHandle = GetAppMainWindow (GetFocus ()) 
Let WinHandle = FindDescendantWindow (WinHandle, Cid_MainEditwindow)
SaveCursor ()
InvisibleCursor ()
if moveToWindow (WinHandle) Then 
	PriorCharacter () ; to include the case when the misspelled word is the first one on the window
	if (FindNextAttribute (attrib_highlight) &&
		(GetWindowClass (GetCurrentWindow ()) == wc_MainEditWindow)) then
		if (GetVerbosity () == beginner) then
			Say(WPErrorMsg3, ot_message) ; "Word in context:"
		EndIf
	SayLine ()
	else
		PCCursor ()
		Say(WpErrorMsg4, ot_message) ; "highlighted word not found"
	EndIf
else
	Say(WPErrorMsg5, ot_message) ; "main document window not found "
EndIf
RestoreCursor ()
PcCursor ()
EndScript

; *** Help section ***

string Function SayCursorPosition (string SearchString)
Var
	Handle WinHandle, 
	String buffer 

let WinHandle = FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CId_StatusBar)
SaveCursor ()
InvisibleCursor ()
if MoveToWindow (WinHandle) then
	FindString (GetCurrentWindow (), SearchString, s_top, s_restricted)
	Let Buffer = GetWord ()
	NextWord ()
	Let Buffer = buffer + " " + getWord ()
	RestoreCursor ()
else
	Say(WPErrorMsg1, ot_message)
EndIf
Return buffer  
EndFunction

; The following functions are modifications of their corresponding 
;built-in or default ones
HANDLE Function GetRealWindow (Handle FocusedWindow)
var
	handle WinHandle,
	handle RealWindow
let WinHandle = FocusedWindow
; search upward the hierarchy to get the handle of the highest 
;dialog window
while (WinHandle)
	if (GetWindowType (WinHandle) == "dialog") then
		let RealWindow = WinHandle
	EndIf
	let WinHandle = GetParent (WinHandle)
EndWhile
if (RealWindow == 0) then ; no dialog was found, then get the first window with name
	let WinHandle = FocusedWindow
	While (WinHandle && (GetWindowName (WinHandle) == ""))
		let WinHandle = GetParent (WinHandle)
	EndWhile
	let RealWindow = WinHandle
EndIf
return RealWindow
EndFunction

String Function GetWindowName (handle WinHandle)
var
	string FirstLine
SaveCursor ()
InvisibleCursor ()
MoveToWindow (WinHandle)
let FirstLine = GetLine ()
if (StringContains (FirstLine, strg1) && 
	StringContains (FirstLine, strg2) && 
	StringContains (FirstLine, strg3)) then
	return strg1 + ", " + strg2 + ", " + strg3 + " Dialog"
EndIf
return GetWindowName (WinHandle)
EndFunction

Int Function DialogActive ()
var
	handle WinHandle
let WinHandle = GetFocus ()
while (WinHandle)
	if (GetWindowType (WinHandle) == "dialog") then
		return active
	EndIf
	let WinHandle = GetParent (WinHandle)
EndWhile
return inactive
EndFunction

Int Function IsMultiPageDialog  ()
var
	handle WinHandle
let WinHandle = GetRealWindow (GetFocus ())
let WinHandle = GetFirstChild (WinHandle)
while (WinHandle)
	if (GetWindowType (WinHandle) == "tab") then
		return true
	EndIf
	let WinHandle = GetNextWindow (WinHandle)
EndWhile
return false

EndFunction


Void Function SayGeneralStatus (string buffer)
Var
	Handle WinHandle ;Window handle of the status bar.

;assign status bar window handle to variable.
Let WinHandle = FindDescendantWindow (GetAppMainWindow (GlobalFocusWindow), CId_StatusBar)
SaveCursor ()
InvisibleCursor ()
;Move the Invisible cursor to the status bar window.
if MoveToWindow (WinHandle) then
;SayInteger (Stringcontains (GetChunk (), buffer))
	If (Stringcontains (GetChunk (), buffer)) && 
	 (PriorInsertStatusFrameBuffer != Buffer) Then 
		Let PriorInsertStatusFrameBuffer = buffer
		If Stringcontains (Buffer, InsertMode) 
		 || StringContains (buffer, OverTypeMode) Then 
	Say(buffer + WPMsg1, ot_buffer)
else
	Say(buffer, ot_buffer)
EndIf
	EndIf
else
	Say(WPErrorMsg1, ot_message) ;"Status bar not found"
endIf 
RestoreCursor ()
PcCursor ()
EndFunction

Function SayFocusedWindow ()
var
	Handle RealWindow, ;Window handle of the window with the title.
	String TheClass, ;The window class name.
	Int PrevControlId, ;Previous control id that the focus was on.
	Int ControlId ;current control Id of window class.

Let RealWindow = GetRealWindow (GlobalFocusWindow)
Let TheClass = GetWindowClass (GlobalFocusWindow)
Let PrevControlId = GetControlId (GlobalPrevFocus)
Let ControlId = GetControlId (GlobalFocusWindow)
;announces when the focus is on the main edit window.
if (TheClass == WC_MainEditWindow) Then  
	Say(WPMsg2, ot_control_name) ;"edit"
EndIf
;Checks for the spell check, Thesaurus and Gramatik dialogue.
;strg1 = Spell checker.
if StringContains (GetWindowName (RealWindow), strg1) then 
	If (ControlID == CId_Replace_With) 
	 || (ControlId == CId_Synonym) 
	 || (ControlId == CId_Synonym2) 
	 || (ControlId == CId_Synonym3) 
	 || (ControlId == CId_Definitions ) Then   
		;we are in the Thesaurus.
		PerformScript  ThesaurusWord ()
		Return 
	EndIf
	If (ControlID == Cid_Replacement) then
		;We are in the Grammatik.
		;not available yet.
		Return 
	EndIf
	if (ControlID == CId_ReplaceWith_field) then 
;	we are in the Spell Checker dialog, announce the new focus.
		If (PrevControlId == CId_DialoguePage) || 
		 (PrevControlId == CId_replacements_list) Then 
			SayWindowTypeAndText (GlobalFocusWindow)
		EndIf 
 		return 
	ElIf ReplaceField && (controlId == CId_replaceButton) then 
		Return 
	EndIf 
	EndIf
;Detects for the Find and replace dialogue 
If (GetWindowClass (GetParent (GetParent (GlobalFocusWindow))) == Wc_FindAndReplace) Then  
	SayFindPrompt () 
	Return 
EndIf
;the next if test checks to see if the current dialog uses graphic check marks.
If ControlCheckMarkDialogs (RealWindow) Then 
	SayDialog ()
EndIf  
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Void Function SayHighlightedText (handle hwnd, string buffer)
;Checks to see if the spell checker is active.
;strg1 = "spell checker" 
if StringContains (GetWindowName (GetRealWindow (GetFocus ())), strg1)  Then
; The spell checker dialogue is active.
;	if (GetFocus () != hwnd) then
;		return
;	EndIf
	If (GetcontrolId (Hwnd) == CId_MainEditWindow) Then  
		If (GetControlId (GlobalFocuswindow) == CId_ReplaceButton) then 
			{Shift+tab}
			{shift+tab}
		endIf 
	;A misspelled word was found, execute readMisspelledAndSuggestion script.
		PerformScript ReadMisSpelledAndSuggestion () 
		Let ReplaceField = FALSE
	EndIf
	Return
endIf ;You are currently in the spell checker.
if(GetScreenEcho() > 0) Then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle HWnd, string Buffer)
var
	string TheClass, ;The window class name of the current window.
	Int ControlId ;Control id of the current window.

let TheClass = GetWindowClass (Hwnd)
Let ControlId = Getcontrolid (hwnd)
;Following if test is from the default script.
If ((GetScreenEcho() > 1)
   ;wn36="#32771"
   || (TheClass == wn36 )) then
	Say(buffer, ot_buffer)
	Return 
EndIf
	;checks to see if new text was written to the status bar.
	If (controlId == CId_StatusBar) Then  
	If (StringContains (buffer, PageNo) == 1) then 
	;Extracts the page number information off the status bar and storesit the buffer variable.
		let buffer = SayCursorPosition (PageNo)
		;Checks to see if the automatic page number option is turned on and 
		;checks to se if the page number has changed. 
		If autoSayPageNo &&
		 (PriorPageNoBuffer != buffer) Then 
			Say(Buffer, ot_buffer) ;announce the new page number.
		;Save buffer contents to prevent the current page number from being repeated continually.
			Let PriorPageNoBuffer = Buffer 
		EndIf 
	else
		SayGeneralStatus (Buffer)
	EndIf ;Stringcontains  (buffer, PageNo)
	Return 
EndIf ;(ControlId == CId_StatusBar) 
;The following "If" test checks for the appearance of the 
;Tool Tip.  when it appears, then the tool tip is announced, 
;only at beginner verbosity level.
If (TheClass  == ToolTip) 
 && (GetVerbosity () == BEGINNER) Then 
	Say(buffer, ot_buffer)
	Return 
EndIf
EndFunction

Void Function SayFindPrompt ()
Var
	Handle HWnd,
	Handle RealWin 

Let Realwin = GetRealwindow (GlobalFocuswindow)
let Hwnd = FindDescendantWindow (RealWin, CId_find_Prompt)
If (GetControlId (GetParent (GlobalFocusWindow)) == CId_EditfindPrompt) Then 
	saywindow (Hwnd, 0)
endIf 
Return 
EndFunction 

void Function SayDialog ()
Var
	String theTitle,
	String TheLine,
	String LastLine

Let TheTitle = GetWindowName (GetRealWindow (GlobalFocusWindow))
If (TheTitle == WN_ExitWordPerfect) 
  || (TheTitle == Wn_FindAndReplace) Then 
	If (GetWindowClass (GlobalPrevFocus) != GetWindowClass (GlobalFocusWindow)) Then 
				SaveCursor ()
		InvisibleCursor ()
		RouteInvisibleToPc ()
		Let LastLine = GetLine ()
		JawsPageUp ()
		NextLine ()
		while (LastLine != theLine)
			SayLine ()
			NextLine ()
			Let TheLine = GetLine ()
		endWhile
			 				RestoreCursor ()
		PcCursor ()
	endIf
EndIf 
EndFunction

Script ThesaurusWord ()
Var
	Int ControlId,
	String BackGroundcolour,
	String ForeGroundColour,
	Handle RealWindow

Let RealWindow = GetRealWindow (globalFocusWindow)
	Let ControlId = GetControlId (globalFocusWindow)
;checks to see if the Thesaurus has no definitions available.
If FindDescendantWindow (RealWindow, 106) 
 && (GetWindowTypecode (GlobalFocusWindow) == WT_LISTBOX) Then 
	Say(WPMsg8, ot_message)
	;gets the previous control id which announces the previous replacement word.
	Let ControlId = controlId - 1
SayWindow (FindDescendantWindow (Realwindow, ControlId), 0)
	Say(WPMsg9, ot_message)
	PcCursor ()
Else
;definition list is available.
	If (ControlId == CId_Definitions) || (ControlId == CID_Synonym) Then 
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		PriorLine ()
		Let BackGroundColour = GetColorName (GetColorBackground ())
		Let ForeGroundColour = GetColorName (GetColorText ())
		If (BackGroundColour == "white") && (ForeGroundColour == "Blue") Then 
			SayControl (GetPriorWindow (GetCurrentWindow ()))
			SayWord ()
			Say(GetWindowType (GlobalFocusWindow), ot_control_name)
			Saywindow (globalFocusWindow, 1)
			Return 
		EndIf
		RestoreCursor ()
		PcCursor ()
	EndIf
endIf 
SayWindowTypeAndText (GlobalFocusWindow)
EndScript

Script SayIndentPosition ()
Var
	String ScriptKeyName,
	String theClass, 
	Handle RealWindow, ;Window handle of the window with the title.
	Int ControlId ;current control Id of window class.

Let RealWindow = GetRealWindow (GlobalFocusWindow)
Let TheClass = GetWindowClass (GlobalFocusWindow)
Let ControlId = GetControlId (GlobalFocusWindow)
Let ScriptKeyname = GetcurrentScriptKeyName ()
If (ScriptKeyName == "tab") Then 
	{Tab}
ElIf (ScriptKeyName == "shift+Tab") Then 
	{shift+tab}
elIf (ScriptKeyName == "f7") Then 
	{F7}
ElIf (ScriptKeyName == "Alt+F7") Then
	{alt+f7}
ElIf (ScriptKeyName == "Control+F7") Then 
	{Control+F7}
ElIf (ScriptKeyName == "Control+Shift+F7") Then
	{Control+shift+f7}
EndIf
if (ControlId == CId_MainEditWindow) 
 && (theClass == wc_MainEditWindow) then
		Say(SayCursorPosition (CharacterPos), ot_position)
EndIf
EndScript

Script SayWpCoordinates ()
Var
	String Buffer ;stores the return string value.

Let Buffer = SayCursorPosition (PageNo)
If (Buffer != "") Then 
	Let buffer = buffer + " " + SayCursorPosition  (LineNo)
	let buffer = buffer + " " + SayCursorPosition (CharacterPos)
	Say(buffer, ot_buffer)
EndIf
EndScript

Script ToggleAutoSayPageNo ()
If AutoSayPageNo Then 
	Let autoSayPageNo = OFF
	Say(WPmsg25+WPMsg27, ot_message)
Else
	Say(WPMsg25+WPMsg26, ot_message)
	Let autoSayPageNo = ON
EndIf
EndScript

Script DocumentContextMenu ()
;The "If" test checks to see if the active cursor is inside the document 
;window.  If the condition is false, then nothing happens.
If (GetWindowclass (GetFocus ()) == wc_MainEditWindow) Then 
	RouteJAWSToPc ()
	JawsCursor ()
	RightMouseButton ()
	PcCursor ()
EndIf
EndScript


Script SayTableCell ()
Var
	String ScriptKeyName, ;stores the current key that envoked the script.
	int controlId, ;stores the current control id.
	String Buffer ;stores the first line of the cell.

Let ScriptKeyname = GetcurrentScriptKeyName ()
let controlId = GetcontrolId (GlobalFocusWindow)
If (ScriptKeyName == "Alt+LeftArrow") Then 
	{alt+left arrow}
	Let buffer = GetChunk ()
ElIf (ScriptKeyName == "Alt+RightArrow") Then 
	{alt+right Arrow}
	Let buffer = GetChunk ()
elIf (ScriptKeyName == "Alt+DownArrow") Then  
	If (ControlId == CId_MainEditWindow) Then  
		{alt+down arrow}
		Let buffer = GetChunk ()
	Else
		PerformScript OpenListbox ()
		return 
	EndIf ;controlId == CId_MainEditwindow 
ElIf (ScriptKeyName == "Alt+UpArrow") Then
	If (ControlId == CId_MainEditWindow) Then  
		{alt+up arrow}
		Let Buffer = GetChunk ()
	Else
		PerformScript OpenListbox ()
		Return 
	EndIf ;controlId == CId_MainEditwindow 
EndIf ;finished checking for keys that are linked to script.
;If the test is TRUE, then the buffer is announced.
If (Buffer == "") Then 
	Say(WPMsg28, ot_message)
else
	Say(buffer, ot_buffer)
endIf ;buffer == ""
EndScript

Script SayInsertMode ()
Var
	String Buffer ;stores the return string value.

{INSERT}
;Let Buffer = SayCursorPosition (InsertMode)
;If (Buffer != "") Then ;
;	Return;
;endIf
;Let Buffer = SayCursorPosition (OverTypeMode)
;If (Buffer != "") Then 
;	Return;
;endIf
EndScript




Script  ScreenSensitiveHelp()
var
	int TheTypeCode,
	String TheClass
Let TheClass = GetWindowClass (GetCurrentWindow ())
let TheTypeCode = GetWindowTypeCode (GetCurrentWindow())
; first handle unknown window types
if (GlobalMenuMode == 1) then

	ScreenSensitiveHelpForKnownClasses()  ;known types
	return
endif
if (TheClass == wc_MainEditWindow) then
	Say(WPHelpMsg1, ot_help) 
	Say(WPHelpMsg2, ot_help)
	Say(WPHelpMsg3, ot_help)
	return
EndIf
if  (TheTypeCode < 1) then
	if (TheTypeCode == WT_UNKNOWN) then
		Say(msg116, ot_help) ;"This is a custom window type"
	endif
	ScreenSensitiveHelpForUnknownClasses()  ; handle unknown window types and classes
else
	ScreenSensitiveHelpForKnownClasses()  ;known types
EndIf
EndScript

Script  HotKeyHelp()
var
	handle WinHandle,
	String TheClass
let WinHandle = GetFocus ()
Let TheClass = GetWindowClass (WinHandle)
if (TheClass == wc_MainEditWindow) then
	Say(WPHelpMsg4, ot_help)
	Say(WPHelpMsg5 + GetScriptKeyName ("SayWpCoordinates"), ot_help)
	Say(WPHelpMsg6 + GetScriptKeyName ("ToggleAutoSayPageNo"), ot_help)
	Say(WPHelpMsg7 + GetScriptKeyName ("SayInsertMode"), ot_help)
	Say(WPHelpMsg32, ot_help)
	Say(WPHelpMsg33 + GetScriptKeyName ("WindowKeysHelp"), ot_help)
	return
EndIf
if StringContains (GetWindowName (GetRealWindow (WinHandle)), strg1) then 
	Say(WPHelpMsg9 + GetScriptKeyName ("ReadMisspelledAndSuggestion"), ot_help)
	Say(WPHelpMsg10 + GetScriptKeyName ("ReadWordInContext"), ot_help)
	return
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script  WindowKeysHelp()
var
	handle WinHandle,
	String TheClass
let WinHandle = GetFocus ()
Let TheClass = GetWindowClass (WinHandle)
if (TheClass == wc_MainEditWindow) then
	Say(WPHelpMsg15, ot_help)
	Say(WPHelpMsg16, ot_help)
	Say(WPHelpMsg17 , ot_help)
	Say(WPHelpMsg18, ot_help)
	Say(WpHelpMsg19, ot_help)
	Say(WpHelpMsg20, ot_help)
	Say(WpHelpMsg21, ot_help)
	Say(WPHelpMsg22, ot_help)
	Say(WpHelpMsg23, ot_help)
	Say(WpHelpMsg24, ot_help)
	Say(WpHelpMsg25, ot_help)
	Say(WpHelpMsg26, ot_help)
	Say(WpHelpMsg27, ot_help)
		Say(WpHelpMsg28, ot_help)
		Say(WpHelpMsg29, ot_help)
		Say(WPHelpMsg30, ot_help)
		Say(WpHelpMsg31, ot_help)
	return
EndIf
WindowKeysHelpDefault ()
EndScript


Script DeleteWord ()
{control+backspace}
SayWord ()
EndScript


Script DeleteToEndOfLine ()
{control+delete}
SayLine ()
EndScript

Script ToggleBoldAttrib ()
AttributeStatus (Attrib_Bold, WPMsg30, WPMsg29, WPMsg35) 
{control+b}
EndScript

Script ToggleUnderLineAttrib ()
AttributeStatus (Attrib_UnderLine, WPMsg32, WPMsg31, WPMsg36) 
{control+u}
EndScript

Script ToggleItalicAttrib ()
AttributeStatus (Attrib_Italic, WPMsg34, WPMsg33, WPMsg37) 
{control+i}
EndScript


Void Function AttributeStatus (int Attribute, string AttribOff, string AttribOn, string AttribHighlighted)
Var
	int col,
	String TheClass ;Current window class

Let TheClass = GetWindowClass (GlobalFocusWindow) ;Stores the current window class name.
If (TheClass == WC_Maineditwindow) then 
	;Currently in the main edit document window.
	If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then 
		;Text is highlighted, announce the new attribute change.
		Say(AttribHighlighted, ot_status)
		Return ;exit back to calling routeroutine.
	endIf 
	;text is not highlighted.
	Let Col = GetCursorCol () ;store the current column pixcel position.
	SaveCursor ()
	RouteInvisibleToPc ()
	PcCursor ()
	PriorCharacter ()
	If (col != GetCursorCol ()) then 
		;the cursor has changed its pixcel position.
		;Other words, the cursor has moved back one character.
		While (Getcharacter () == "")
			;Loop keeps moving back one character at a time,
			;while the current character is a null.
			PriorCharacter ()
		endwhile 
		;found a character.
		If (GetCharacterAttributes () & Attribute) then 
		;since the prior character is the same attribute.  The attribute has been turned off.
			Say(AttribOff, ot_status) ;announce that the attribute has been turned off.
		else
			Say(AttribOn, ot_status) ;announce that the attribute has been turned on.
		endIf 
	RoutePcToInvisible ()
	Else
	;cursor must be at the top of the document.
		Say(AttribOn, ot_status) ;Announce that the attribute has been turned on.
	endIf 
	RestoreCursor ()
	PcCursor ()
EndIf ;(Controlid == CId_MainEditWindow)
EndFunction





